# WordPress integration

Folder: `integrations/wordpress/portcore-geoip/`

## Install

1. Copy `portcore-geoip` into `wp-content/plugins/`.
2. Activate plugin in WordPress admin.
3. Open `Settings -> Portcore GEOIP` and save:
   - API Endpoint URL
   - API Key

## Call by IP

```php
$geo = pc_geoip_lookup('2001:bc8:1da0:1e:da5e:d3ff:fe6f:dc87');
```

Optional context override:

```php
$geo = pc_geoip_lookup('8.8.8.8', [
  'user_id' => 'crm_501',
  'user_agent' => 'Custom-UA/1.0',
]);
```

## Render summary from array

```php
echo pc_geoip_render_summary($geo);
```

## Shortcode

`[portcore_geoip_summary data='{"ip":"8.8.8.8","country":"US"}']`

