# Joomla integration

Folder: `integrations/joomla/plg_system_portcoregeoip/`

## Install

1. Copy folder into Joomla plugins path:
   - `plugins/system/portcoregeoip/`
2. Install/enable plugin `System - Portcore GEOIP Integration`.
3. In plugin params set:
   - API Endpoint URL
   - API Key

## Lookup by specific IP

```php
$geo = PortcoreGeoipHelper::getByIp('2001:bc8:1da0:1e:da5e:d3ff:fe6f:dc87');
```

Optional context:

```php
$geo = PortcoreGeoipHelper::getByIp('8.8.8.8', [
  'user_id' => 'crm_501',
  'user_agent' => 'Custom-UA/1.0',
]);
```

## Render summary

```php
echo PortcoreGeoipHelper::renderSummary($geo);
```

