<?php

namespace Drupal\portcore_geoip\Form;

use Drupal\Core\Form\ConfigFormBase;
use Drupal\Core\Form\FormStateInterface;

class SettingsForm extends ConfigFormBase {

  protected function getEditableConfigNames(): array {
    return ['portcore_geoip.settings'];
  }

  public function getFormId(): string {
    return 'portcore_geoip_settings_form';
  }

  public function buildForm(array $form, FormStateInterface $form_state): array {
    $cfg = $this->config('portcore_geoip.settings');

    $form['api_endpoint'] = [
      '#type' => 'textfield',
      '#title' => $this->t('API Endpoint URL'),
      '#default_value' => (string) $cfg->get('api_endpoint'),
      '#required' => FALSE,
      '#maxlength' => 1024,
      '#placeholder' => 'https://geoip.space/api/check/',
    ];

    $form['api_key'] = [
      '#type' => 'textfield',
      '#title' => $this->t('API Key'),
      '#default_value' => (string) $cfg->get('api_key'),
      '#required' => FALSE,
      '#maxlength' => 1024,
    ];

    return parent::buildForm($form, $form_state);
  }

  public function submitForm(array &$form, FormStateInterface $form_state): void {
    $this->configFactory()->getEditable('portcore_geoip.settings')
      ->set('api_endpoint', trim((string) $form_state->getValue('api_endpoint')))
      ->set('api_key', trim((string) $form_state->getValue('api_key')))
      ->save();

    parent::submitForm($form, $form_state);
  }
}

