# Drupal integration

Folder: `integrations/drupal/portcore_geoip/`

## Install

1. Copy `portcore_geoip` into `web/modules/custom/`.
2. Enable module:
   - `drush en portcore_geoip` or via admin UI.
3. Configure:
   - `/admin/config/services/portcore-geoip`

## Lookup by specific IP

```php
$geo = portcore_geoip_lookup('2001:bc8:1da0:1e:da5e:d3ff:fe6f:dc87');
```

Optional context:

```php
$geo = portcore_geoip_lookup('8.8.8.8', [
  'user_id' => 'crm_501',
  'user_agent' => 'Custom-UA/1.0',
]);
```

## Build GEOIP summary array

```php
$summary = portcore_geoip_summary_array($geo, FALSE);
```

