<?php
use Bitrix\Main\Application;
use Bitrix\Main\Localization\Loc;

if (!defined('B_PROLOG_INCLUDED') || B_PROLOG_INCLUDED !== true) {
    die();
}

Loc::loadMessages(__FILE__);
require_once __DIR__ . '/include.php';

global $USER;
if (!$USER->IsAdmin()) {
    return;
}

$moduleId = \Portcore\Geoip\Settings::MODULE_ID;
$request = Application::getInstance()->getContext()->getRequest();

if ($request->isPost() && check_bitrix_sessid()) {
    \Portcore\Geoip\Settings::setEndpoint((string)$request->getPost('api_endpoint'));
    \Portcore\Geoip\Settings::setApiKey((string)$request->getPost('api_key'));
    CAdminMessage::ShowMessage([
        'TYPE' => 'OK',
        'MESSAGE' => 'GEOIP settings saved.',
    ]);
}

$endpoint = \Portcore\Geoip\Settings::getEndpoint();
$apiKey = \Portcore\Geoip\Settings::getApiKey();
?>
<form method="post" action="<?= htmlspecialchars($APPLICATION->GetCurPageParam(), ENT_QUOTES) ?>">
    <?= bitrix_sessid_post() ?>
    <input type="hidden" name="mid" value="<?= htmlspecialchars($moduleId, ENT_QUOTES) ?>">

    <table class="adm-detail-content-table edit-table">
        <tr>
            <td width="40%">API Endpoint URL</td>
            <td width="60%">
                <input
                    type="text"
                    name="api_endpoint"
                    value="<?= htmlspecialchars($endpoint, ENT_QUOTES) ?>"
                    style="width:100%;"
                    placeholder="https://geoip.space/api/check/"
                >
            </td>
        </tr>
        <tr>
            <td>API Key</td>
            <td>
                <input
                    type="text"
                    name="api_key"
                    value="<?= htmlspecialchars($apiKey, ENT_QUOTES) ?>"
                    style="width:100%;"
                    placeholder="your_api_key"
                >
            </td>
        </tr>
    </table>

    <div style="margin-top:12px;">
        <input type="submit" class="adm-btn-save" value="Save">
    </div>
</form>

