<?php
if (!defined('B_PROLOG_INCLUDED') || B_PROLOG_INCLUDED !== true) {
    die();
}

$input = $arParams['GEOIP_ARRAY'] ?? [];
if (!is_array($input)) {
    if (is_string($input) && trim($input) !== '') {
        $decoded = json_decode($input, true);
        $input = is_array($decoded) ? $decoded : [];
    } else {
        $input = [];
    }
}

$pick = static function (array $source, array $paths, $default = '') {
    foreach ($paths as $path) {
        $cursor = $source;
        $ok = true;
        foreach (explode('.', $path) as $segment) {
            if (!is_array($cursor) || !array_key_exists($segment, $cursor)) {
                $ok = false;
                break;
            }
            $cursor = $cursor[$segment];
        }
        if ($ok && $cursor !== null && $cursor !== '') {
            return $cursor;
        }
    }
    return $default;
};

$summary = [
    'ip' => (string)$pick($input, ['ip', 'query']),
    'country_code' => (string)$pick($input, ['country_code', 'country.iso_code', 'countryCode']),
    'country_name' => (string)$pick($input, ['country_name', 'country.name', 'country']),
    'region' => (string)$pick($input, ['region', 'region_name', 'subdivisions.0.name']),
    'city' => (string)$pick($input, ['city', 'city_name', 'city.name']),
    'asn' => (string)$pick($input, ['asn', 'as.number', 'network.asn']),
    'org' => (string)$pick($input, ['org', 'organization', 'as.organization', 'network.organization']),
    'timezone' => (string)$pick($input, ['timezone', 'location.time_zone']),
    'latitude' => (string)$pick($input, ['latitude', 'location.latitude']),
    'longitude' => (string)$pick($input, ['longitude', 'location.longitude']),
    'is_proxy' => (string)$pick($input, ['is_proxy', 'security.is_proxy']),
    'is_vpn' => (string)$pick($input, ['is_vpn', 'security.is_vpn']),
    'is_tor' => (string)$pick($input, ['is_tor', 'security.is_tor']),
    'risk_score' => (string)$pick($input, ['risk_score', 'risk.score']),
];

$showEmpty = (string)($arParams['SHOW_EMPTY'] ?? 'N') === 'Y';
if (!$showEmpty) {
    $summary = array_filter($summary, static function ($v) {
        return $v !== '';
    });
}

$arResult['RAW'] = $input;
$arResult['SUMMARY'] = $summary;

$this->includeComponentTemplate();

