# Bitrix GEOIP integration module

Path: `integration/bitrix/portcore.geoip`

## What is included

- Module `portcore.geoip` with admin settings:
  - `API Endpoint URL`
  - `API Key`
- Component `portcore:geoip.summary`
  - Accepts GEOIP array (or JSON string)
  - Outputs key GEOIP fields in table form for further use in templates and logic
- Helper classes:
  - `\Portcore\Geoip\Settings`
  - `\Portcore\Geoip\Client`

## Manual install (without archive)

1. Copy folder:
   - from `integration/bitrix/portcore.geoip`
   - to `<bitrix_root>/bitrix/modules/portcore.geoip`
2. Install module in Bitrix admin: `Settings -> Module list`.
3. Open module settings and save:
   - Endpoint URL
   - API key

## Component usage

```php
<?php
$geo = [
    'ip' => '8.8.8.8',
    'country' => ['iso_code' => 'US', 'name' => 'United States'],
    'city' => ['name' => 'Mountain View'],
    'as' => ['number' => 15169, 'organization' => 'Google LLC'],
    'location' => ['time_zone' => 'America/Los_Angeles', 'latitude' => 37.386, 'longitude' => -122.0838],
    'security' => ['is_proxy' => false, 'is_vpn' => false, 'is_tor' => false],
    'risk' => ['score' => 12]
];

$APPLICATION->IncludeComponent(
    'portcore:geoip.summary',
    '.default',
    [
        'GEOIP_ARRAY' => $geo, // or JSON string
        'SHOW_EMPTY' => 'N',
    ]
);
```

## API lookup helper example

```php
<?php
\Bitrix\Main\Loader::includeModule('portcore.geoip');
$result = \Portcore\Geoip\Client::lookup('8.8.8.8');
// alias:
// $result = \Portcore\Geoip\Client::getByIp('8.8.8.8');
```

## What is sent to API request

Module sends normalized IP and context:

- IP:
  - strict validation (`IPv4` / `IPv6`)
  - brackets are removed for IPv6 input format like `[2001:db8::1]`
- `user_id`:
  - `bxu_{BITRIX_USER_ID}` for authorized user
  - fallback `bxs_{session_hash}` for guest
- `user_agent`:
  - current request UA from `$_SERVER['HTTP_USER_AGENT']`
  - fallback `Bitrix-PortcoreGeoip/1.0`

Request carries context both in query params (`user_id`, `ua`) and headers:

- `X-Api-Key`
- `X-User-Id`
- `User-Agent`

## Explicit lookup by any IP (documented call)

```php
<?php
\Bitrix\Main\Loader::includeModule('portcore.geoip');

$ip = '2001:bc8:1da0:1e:da5e:d3ff:fe6f:dc87';
$geo = \Portcore\Geoip\Client::getByIp($ip, [
    // optional overrides:
    // 'user_id' => 'crm_lead_501',
    // 'user_agent' => 'Custom-Agent/1.0',
    // 'endpoint' => 'https://geoip.space/api/check/',
    // 'api_key' => 'your_api_key',
]);
```
