<?php
namespace Portcore\Geoip;

use Bitrix\Main\Config\Option;

class Settings
{
    public const MODULE_ID = 'portcore.geoip';
    public const OPT_ENDPOINT = 'api_endpoint';
    public const OPT_API_KEY = 'api_key';

    public static function getEndpoint(): string
    {
        return trim((string)Option::get(self::MODULE_ID, self::OPT_ENDPOINT, ''));
    }

    public static function setEndpoint(string $endpoint): void
    {
        Option::set(self::MODULE_ID, self::OPT_ENDPOINT, trim($endpoint));
    }

    public static function getApiKey(): string
    {
        return trim((string)Option::get(self::MODULE_ID, self::OPT_API_KEY, ''));
    }

    public static function setApiKey(string $apiKey): void
    {
        Option::set(self::MODULE_ID, self::OPT_API_KEY, trim($apiKey));
    }
}

