<?php
use Bitrix\Main\Localization\Loc;
use Bitrix\Main\ModuleManager;

if (!defined('B_PROLOG_INCLUDED') || B_PROLOG_INCLUDED !== true) {
    die();
}

Loc::loadMessages(__FILE__);

class portcore_geoip extends CModule
{
    public $MODULE_ID = 'portcore.geoip';
    public $MODULE_VERSION;
    public $MODULE_VERSION_DATE;
    public $MODULE_NAME = 'Portcore GEOIP Integration';
    public $MODULE_DESCRIPTION = 'Stores GEOIP API endpoint/key and provides GEOIP summary component.';
    public $PARTNER_NAME = 'Portcore';
    public $PARTNER_URI = 'https://portcore.ru/';

    public function __construct()
    {
        $arModuleVersion = [];
        include __DIR__ . '/version.php';
        if (is_array($arModuleVersion)) {
            $this->MODULE_VERSION = (string)($arModuleVersion['VERSION'] ?? '1.0.0');
            $this->MODULE_VERSION_DATE = (string)($arModuleVersion['VERSION_DATE'] ?? date('Y-m-d H:i:s'));
        }
    }

    public function DoInstall()
    {
        ModuleManager::registerModule($this->MODULE_ID);
        $this->installFiles();
    }

    public function DoUninstall()
    {
        $this->unInstallFiles();
        ModuleManager::unRegisterModule($this->MODULE_ID);
    }

    protected function installFiles()
    {
        $from = __DIR__ . '/components';
        $to = $_SERVER['DOCUMENT_ROOT'] . '/bitrix/components';
        if (is_dir($from)) {
            CopyDirFiles($from, $to, true, true);
        }
    }

    protected function unInstallFiles()
    {
        $componentPath = $_SERVER['DOCUMENT_ROOT'] . '/bitrix/components/portcore/geoip.summary';
        if (is_dir($componentPath)) {
            DeleteDirFilesEx('/bitrix/components/portcore/geoip.summary');
        }
    }
}

