<?php
if (!defined('B_PROLOG_INCLUDED') || B_PROLOG_INCLUDED !== true) {
    die();
}

class PortcoreGeoipSummaryComponent extends CBitrixComponent
{
    protected function parseInput()
    {
        $input = $this->arParams['GEOIP_ARRAY'] ?? [];
        if (is_array($input)) {
            return $input;
        }

        if (!is_string($input)) {
            return [];
        }

        $input = trim($input);
        if ($input === '') {
            return [];
        }

        $json = json_decode($input, true);
        if (is_array($json)) {
            return $json;
        }

        return [];
    }

    protected function pick(array $source, array $paths, $default = '')
    {
        foreach ($paths as $path) {
            $cursor = $source;
            $ok = true;
            foreach (explode('.', $path) as $segment) {
                if (!is_array($cursor) || !array_key_exists($segment, $cursor)) {
                    $ok = false;
                    break;
                }
                $cursor = $cursor[$segment];
            }
            if ($ok && $cursor !== null && $cursor !== '') {
                return $cursor;
            }
        }
        return $default;
    }

    public function executeComponent()
    {
        $src = $this->parseInput();

        $summary = [
            'ip' => (string)$this->pick($src, ['ip', 'query']),
            'country_code' => (string)$this->pick($src, ['country_code', 'country.iso_code', 'countryCode']),
            'country_name' => (string)$this->pick($src, ['country_name', 'country.name', 'country']),
            'region' => (string)$this->pick($src, ['region', 'region_name', 'subdivisions.0.name']),
            'city' => (string)$this->pick($src, ['city', 'city_name', 'city.name']),
            'asn' => (string)$this->pick($src, ['asn', 'as.number', 'network.asn']),
            'org' => (string)$this->pick($src, ['org', 'organization', 'as.organization', 'network.organization']),
            'timezone' => (string)$this->pick($src, ['timezone', 'location.time_zone']),
            'latitude' => (string)$this->pick($src, ['latitude', 'location.latitude']),
            'longitude' => (string)$this->pick($src, ['longitude', 'location.longitude']),
            'is_proxy' => (string)$this->pick($src, ['is_proxy', 'security.is_proxy']),
            'is_vpn' => (string)$this->pick($src, ['is_vpn', 'security.is_vpn']),
            'is_tor' => (string)$this->pick($src, ['is_tor', 'security.is_tor']),
            'risk_score' => (string)$this->pick($src, ['risk_score', 'risk.score']),
        ];

        $showEmpty = (string)($this->arParams['SHOW_EMPTY'] ?? 'N') === 'Y';
        if (!$showEmpty) {
            $summary = array_filter($summary, static function ($v) {
                return $v !== '';
            });
        }

        $this->arResult['RAW'] = $src;
        $this->arResult['SUMMARY'] = $summary;
        $this->includeComponentTemplate();
    }
}

